@ECHO OFF
REM ///////////////////////////////////////////////////////////////////////////
REM
REM Copyright (c) 2007,2008 Daniel Adler <dadler@uni-goettingen.de>, 
REM                         Tassilo Philipp <tphilipp@potion-studios.com>
REM
REM Permission to use, copy, modify, and distribute this software for any
REM purpose with or without fee is hereby granted, provided that the above
REM copyright notice and this permission notice appear in all copies.
REM
REM THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
REM WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
REM MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
REM ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
REM WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
REM ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
REM OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
REM
REM ///////////////////////////////////////////////////////////////////////////


REM Set default values.
SET BUILD_OS=windows
SET BUILD_ARCH=x86
SET BUILD_TOOL=msvc
SET BUILD_ASM=ml
SET BUILD_CONFIG=release
SET INSTALL_DIR=%CD%


REM Scan arguments.
:MAIN_LOOP


REM Help.
IF [%1]==[] (
	GOTO DONE
) ELSE IF [%1]==[/?] (
	ECHO.
	ECHO.dyncall configuration shell-script
	ECHO.Usage:
	ECHO.  configure.bat [ options ]
	ECHO.
	ECHO.Options:
	ECHO.  /?               print this page
	ECHO.
	ECHO.  /prefix PATH     set installation prefix ^(defaults to './install'^)
	ECHO.                   ^(only for use with gmake^)
	ECHO.
	ECHO.  /target-x86      build for x86 architecture ^(default^)
	ECHO.  /target-x64      build for x64 architecture
	ECHO.  /target-psp      build for Playstation Portable ^(homebrew SDK^)
	ECHO.  /target-nds      build for Nintendo DS ^(devkitPro, ARM mode ^(not THUMB^)^)
	ECHO.
	ECHO.  /tool-msvc       use Microsoft Visual C++ compiler ^(default^)
	ECHO.  /tool-gcc        use GNU Compiler Collection
	ECHO.
	ECHO.  /asm-ml          use Microsoft Macro Assembler ^(default^)
	ECHO.  /asm-as          use the GNU Assembler
	ECHO.  /asm-nasm        use NASM Assembler
	ECHO.
	ECHO.  /config-release  build release version ^(default^)
	ECHO.  /config-debug    build debug version
) ELSE IF [%1]==[/prefix] (
	SET INSTALL_DIR=%2
	SHIFT
) ELSE IF [%1]==[/target-x86] (
	SET BUILD_ARCH=x86
) ELSE IF [%1]==[/target-x64] (
	SET BUILD_ARCH=x64
) ELSE IF [%1]==[/target-psp] (
	SET BUILD_ARCH=mips32
	SET BUILD_OS=psp
) ELSE IF [%1]==[/target-nds] (
	SET BUILD_ARCH=arm9e_arm
	SET BUILD_OS=nds
) ELSE IF [%1]==[/tool-gcc] (
	SET BUILD_TOOL=gcc
	SET BUILD_ASM=as
) ELSE IF [%1]==[/tool-msvc] (
	SET BUILD_TOOL=msvc
	SET BUILD_ASM=ml
) ELSE IF [%1]==[/asm-as] (
	SET BUILD_ASM=as
) ELSE IF [%1]==[/asm-nasm] (
	SET BUILD_ASM=nasm
) ELSE IF [%1]==[/asm-ml] (
	SET BUILD_ASM=ml
) ELSE IF [%1]==[/config-release] (
	SET BUILD_CONFIG=release
) ELSE IF [%1]==[/config-debug] (
	SET BUILD_CONFIG=debug
) ELSE (
	ECHO Unknown parameter '%1'.
	GOTO DONE
)

SHIFT
GOTO MAIN_LOOP
:DONE

ECHO # auto-generated by configure.bat >ConfigVars
ECHO BUILD_OS=%BUILD_OS%#>>ConfigVars
ECHO BUILD_ARCH=%BUILD_ARCH%#>>ConfigVars
ECHO BUILD_TOOL=%BUILD_TOOL%#>>ConfigVars
ECHO BUILD_ASM=%BUILD_ASM%#>>ConfigVars
ECHO BUILD_CONFIG=%BUILD_CONFIG%#>>ConfigVars
ECHO INSTALL_DIR=%INSTALL_DIR%#>>ConfigVars



REM We have to transform some pathes for the nds/devkitPro build.
IF [%BUILD_OS%]==[nds] (

REM Check if DEVKITPRO is set.
IF [%DEVKITPRO%]==[] (
	ECHO ERROR: Environment variable DEVKITPRO must be set to absolute devkitPro path.
) ELSE (
	conf-nds.bat
)

)
